/***********************************************************************
 *
 * Copyright (c) 2000 PalmSource, Inc. or its subsidiaries.
 * All rights reserved.
 *
 ***********************************************************************
 *
 * FILE:
 *	VPIncs.h
 *
 * DESCRIPTION:
 *	
 *
 * AUTHOR:
 *	June  1, 2000	Created by Sami Hindawi(SHi)
 *	mmmm dd, yyyy	Now owned by .....
 *
 ***********************************************************************/

#ifndef CATMESSAGE_H
#define CATMESSAGE_H

#include "ShTarget.h"
#include <string.h>
/////////////////////////////////////////////////////////////////////////////
const UInt16 kMaxATMessageLength = 1024;
/////////////////////////////////////////////////////////////////////////////
class CATMessage
{
public:
	UInt8	mBuf[kMaxATMessageLength];
	UInt16	mDataLen;
	UInt16	mBufSize;
	UInt8	mChannel;
	CATMessage()
		{
		mBufSize = kMaxATMessageLength;
		mDataLen = 0;
		mChannel=(UInt8)-1;
		memset(mBuf,0,mBufSize);
		};
};
///////////////////////////////////////////////////////////////////////////////

class CDataMessage : public CATMessage
{
protected:
	Bool		mTurnOffDataMode;
public:

	CDataMessage(CATMessage* iMsg)
		{
		memset(mBuf,0,mBufSize);
		mBufSize=iMsg->mBufSize;
		mDataLen = iMsg->mDataLen;
		memcpy(mBuf, iMsg->mBuf, mDataLen);
		mChannel= iMsg->mChannel;
		mTurnOffDataMode=false;
		};

	Bool IsDataModeTurnedOff()	{return mTurnOffDataMode;};
	void TurnOffDataMode()		{mTurnOffDataMode=true;};
};
/////////////////////////////////////////////////////////////////////////////
#endif // CATMESSAGE_H
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////